//----------------------------------------------------------------
// Funktion DS18B20 - Temperatur
//----------------------------------------------------------------
# if ((Anzahl_Sensoren_DS18B20 > 0) and (Anzahl_Sensoren_DS18B20 < 5))

#include <OneWire.h>


void Sensor_DS18B20() {  // search sensors and read out data

#define STARTCONVERSION  0x44  // Tells device to take a temperature reading and put it on the scratchpad
#define READSCRATCH      0xBE  // Read DS18B20
#define CRC_SCRATCH       8
  // #define Sensor_Aufloesung 12//  default is 12 bit

  uint8_t DS18B20_Adresse[8];  // DS18B20 ID
  float Temperatur_DS;
  uint8_t parasite = 0;  // need 5V on the sensor
  uint8_t scratchPad[9];
  uint8_t devices = 0;

  debugprintlnF("DS18B20");

  OneWire my_O_Wire(ONE_WIRE_BUS);

  //  my_O_Wire.reset_search();

  while (my_O_Wire.search(DS18B20_Adresse)) { // search devices
    if (my_O_Wire.crc8(DS18B20_Adresse, 7) == DS18B20_Adresse[7]) {
      devices++;
    }
  }

  // send command for all devices on the bus to perform a temperature conversion
  my_O_Wire.reset();
  my_O_Wire.skip();
  my_O_Wire.write(STARTCONVERSION, parasite);

  LogDelay(1000); // wait for conversion, 12 bit resolution needs at least 750ms

  if (devices >= Anzahl_Sensoren_DS18B20) {
    devices = Anzahl_Sensoren_DS18B20;
  }

  for (uint8_t i = 0; i < devices; i++) {
    Temperatur_DS = No_Val;
    if (my_O_Wire.search(DS18B20_Adresse)) { // search next
      if (my_O_Wire.crc8(DS18B20_Adresse, 7) == DS18B20_Adresse[7]) { // valid?
        //print_DS_adress(DS18B20_Adresse);

        my_O_Wire.reset();
        my_O_Wire.select(DS18B20_Adresse);
        my_O_Wire.write(READSCRATCH);        // read scratchpad
        // Read all registers in a simple loop
        // byte 0: temperature LSB
        // byte 1: temperature MSB
        // byte 2: high alarm temp
        // byte 3: low alarm temp
        // byte 4: DS18S20: store for crc
        //         DS18B20 & DS1822: configuration register
        // byte 5: internal use & crc
        // byte 6: DS18S20: COUNT_REMAIN
        //         DS18B20 & DS1822: store for crc
        // byte 7: DS18S20: COUNT_PER_C
        //         DS18B20 & DS1822: store for crc
        // byte 8: SCRATCHPAD_CRC
        for (uint8_t k = 0; k < 9; k++) {
          scratchPad[k] = my_O_Wire.read();
        }
        my_O_Wire.reset();

        if (my_O_Wire.crc8(scratchPad, CRC_SCRATCH) == scratchPad[CRC_SCRATCH]) {  // if CRC o.k.
          Temperatur_DS = (float)((scratchPad[1] << 8) + scratchPad[0]);  // MSB + LSB
          Temperatur_DS = (Temperatur_DS / 16.0);        // 12Bit = 0,0625 C per Bit (-> divide by 16)
        }
        else {
          debugprintln("Fehler");
        }
      } // crc
    } // search

    // Zuordnung Sensorwerte
    if (i == 4) { // der fünfte DS18B20
      SensorTemp[0] = Temperatur_DS;  // 5. DS18B20 in Temp [0]
    }
    else {
      SensorTemp[8 + i] = Temperatur_DS; // 8,9,10,11
    }

#if (Anzahl_Sensoren_Gewicht < 3) // Single/Double System
#if (Anzahl_Sensoren_DS18B20 == 2) // 2 DS18B20
    SensorFeuchte[8] = Temperatur_DS;  // 2. DS18B20 in Feuchte[]
#else
    if (i == 2) { // 3. DS18B20
      SensorFeuchte[8] = Temperatur_DS;  // 3. DS18B20 in Feuchte[]
    }
    if (i == 3) { // 4. DS18B20
      SensorFeuchte[9] = Temperatur_DS;  // 4. DS18B20 in Feuchte[]
    }
#endif
#endif

  } // for
}
#else
void Sensor_DS18B20() {};
#endif
//----------------------------------------------------------------
