//08.04.2020  delay in DS18B20
//13.04.2020  Duo-System
//18.06.2020  var default in DS18B20
//03.07.2020  Korrektur Luftdruck auf Standort
//18.07.2020  ignoriere Waagen ohne Kal-Werte
//02.09.2020  Waagen ohne Kal-Werte
// 25.10.2020  Temperatur Waegezelle
// 30.12.2020  neue HX711 Lib
// 03.01.2021  neue HX711 Lib
// 01.03.2021  DS18B20 Zuordnung
// 04.10.2021 HX711 adresss struct
// 06.05.2022 DHT delay
// 23.06.2022 SI7021 value check
// 28.01.2023 use Adafuit DHT lib
// 18.02.2023 wait for stable HX711
// 15.04.2023 BME-/DHT- beelogger-Libs
// 15.05.2023 BH1750 I2C Adressierung
// 03.05.2024  split functions in files

//----------------------------------------------------------------
#include <Wire.h>

//----------------------------------------------------------------
//Konfiguration Bienenzähler
//----------------------------------------------------------------
#include <Adafruit_MCP23017.h>
Adafruit_MCP23017 mcp[Anzahl_Sensoren_Bienenzaehler];
//----------------------------------------------------------------


//----------------------------------------------------------------
// Setup the sensors and their instances
//----------------------------------------------------------------
void setup_sensor_BZ() {

  //----------------------------------------------------------------
  // Setup Bienenzähler
  //----------------------------------------------------------------
#if ((Anzahl_Sensoren_Bienenzaehler > 0) and (Anzahl_Sensoren_Bienenzaehler < 6))

  debugprintF("Setup: Bienenzaehler konfiguriert: ");
  debugprintln(Anzahl_Sensoren_Bienenzaehler);
  debugflush();

  for (uint8_t j = 0; j < Anzahl_Sensoren_Bienenzaehler; j++) {
    mcp[j].begin(j + 4);
    debugprintF("begin:"); debugprintln(j + 1); debugflush();
    for (uint8_t i = 0; i < 16; i++) {
      mcp[j].pinMode(i, INPUT);
      mcp[j].pullUp(i, LOW);
      LetzterSensor[j][i] = 0;
    }
  }
  BienenIntervall = millis();
  debugprintF("read...");debugflush();
  Sensor_Bienen();
  debugprintlnF("done");debugflush();
#endif
  //----------------------------------------------------------------

}
//----------------------------------------------------------------


//----------------------------------------------------------------
// Funktion BienenTacho
//----------------------------------------------------------------
void BienenTachoCalc() {
#if (Anzahl_Sensoren_Bienenzaehler > 0)
  uint32_t tmptime = ( millis() -  BienenIntervall);
  BienenOutTacho = (int)(( -0.49 + (60000.0 / (float)tmptime) * (float)BienenOut));
  BienenInTacho  = (int)(( 0.49 + (60000.0 / (float)tmptime) * (float)BienenIn));

  debugprint((int)(tmptime / 1000)); debugprintln(" sec");
  debugprint("Bienen in Summe (raus | rein): "); debugprint(BienenOut); debugprint(" | "); debugprintln(BienenIn);
  debugprint("Bienen je min   (raus | rein): "); debugprint(BienenOutTacho); debugprint(" | "); debugprintln(BienenInTacho);
#endif
}
//----------------------------------------------------------------



//----------------------------------------------------------------
// Funktion Bienenzähler
//----------------------------------------------------------------
void Sensor_Bienen() {
#if ((Anzahl_Sensoren_Bienenzaehler > 0) and (Anzahl_Sensoren_Bienenzaehler < 5))
  for (uint8_t j = 0; j < Anzahl_Sensoren_Bienenzaehler; j++) {

    for (uint8_t i = 0; i < 16; i++) {
      SensorAktuell[i] = mcp[j].digitalRead(i);
      /*
              debugprint("Bienensensor Nr.:  ");
              debugprint(i + 1);
              debugprint("  Messwert:  ");
              debugprintln(SensorAktuell[i]);
              debugflush();
      */
    }
#if Neue_Bienenzaehlfunktion  // neue Methode  Bienenzählfunktion
    for (uint8_t i = 0; i < 8; i++) {
      TunnelZuvor = TunnelZustand[j][i];
      if ((SensorAktuell[i] == 0) && ( SensorAktuell[i + 8] == 0 )) {
        if ( TunnelZustand[j][i] == 3) {
          BienenOut--;
#if myDEBUG
          debugprintln("Biene raus !");
          BienenTachoCalc();
#endif
        }
        else if ( TunnelZustand[j][i] == 13) {
          BienenIn++;
#if myDEBUG
          debugprintln("Biene rein !");
          BienenTachoCalc();
#endif
        }
        TunnelZustand[j][i] = 0;
      }
      else if ((SensorAktuell[i] == 0) && ( SensorAktuell[i + 8]) == 1 ) {
        if   (( TunnelZustand[j][i] == 0 ) || (TunnelZustand[j][i] == 2 )) TunnelZustand[j][i] = 1;
        else if ( TunnelZustand[j][i] == 12 ) TunnelZustand[j][i] = 13;
      }
      else if ((SensorAktuell[i] == 1) && ( SensorAktuell[i + 8]) == 1 ) {
        if   (( TunnelZustand[j][i] == 1 ) ||  ( TunnelZustand[j][i] == 3 )) TunnelZustand[j][i] = 2;
        else if (( TunnelZustand[j][i] == 11 ) || ( TunnelZustand[j][i] == 13 )) TunnelZustand[j][i] = 12;
      }
      else if ((SensorAktuell[i] == 1) && ( SensorAktuell[i + 8]) == 0 ) {
        if   ( TunnelZustand[j][i] == 2 ) TunnelZustand[j][i] = 3;
        else if (( TunnelZustand[j][i] == 0 ) || (TunnelZustand[j][i] == 12 ))  TunnelZustand[j][i] = 11;
      }
#if myDEBUG
      if (TunnelZustand[j][i] != TunnelZuvor) {
        debugprint(TunnelZuvor); debugprint("->"); debugprintln(TunnelZustand[j][i]);
      }
#endif
    }

#else  // alte Bienenzählfunktion
    for (uint8_t i = 0; i < 8; i++) {
      if (SensorAktuell[i] != LetzterSensor[j][i]) {
        if (SensorAktuell[i] > SensorAktuell[i + 8]) {
          if (BienenIn == -1) BienenIn = 1;
          else  BienenIn++;
        }
      }
      if (SensorAktuell[i + 8] != LetzterSensor[j][i + 8]) {
        if (SensorAktuell[i + 8] > SensorAktuell[i]) {
          if (BienenOut == -1) BienenOut = 1;
          else BienenOut++;
        }
      }
      LetzterSensor[j][i] = SensorAktuell[i];
      LetzterSensor[j][i + 8] = SensorAktuell[i + 8];
    }
#endif
  }
  delay(10);
#endif
}
//----------------------------------------------------------------
