#include <HX711.h>

/**
  @brief Funktion   Sensor_Gewicht

  initialisiere HX711, hole Messwerte, berechne Gewicht,
  vergleiche Schwarmalarmgewicht,
  unterdrücke kurzzeitige Messwertfehler


  @param  quick: kein Test auf Veränderungen zum alten Messwert.
  @return  überschreiten Schwarmalarmgewicht = 1
          Messwerte in globalen Variablen
*/
void Sensor_Gewicht(uint8_t quick) {

#if ((Anzahl_Sensoren_Gewicht > 0) && (Anzahl_Sensoren_Gewicht < 3))

  const float Diff_Gewicht = 0.5;

  HX711 scale;
  scale.begin(HX711_DT[0], HX711_SCK[0], 128); // Nr.1 Kanal A
  for (uint8_t i = 0; i < Anzahl_Sensoren_Gewicht; i++) {
    if (i == 1) {
      scale.set_gain(32);  // Nr.1 Kanal B
    }
    if (Taragewicht[i] != 10) {
      scale.power_up();
      uint8_t count = 0, retries = 5;
      while (count < retries) {
        LogDelay(600);  // wait for HX711
        if (scale.is_ready()) {
          break;
        }
        count++;
      }
      if (count < 5) { // scale found
        scale.read(); // set gain using read
        LogDelay(600);  // wait for stable HX711
        for (uint8_t j = 0 ; j < 2; j++) { // Anzahl der Wiederholungen, wenn Abweichung zum letzten Gewicht zu hoch
          long l_gew = scale.read_average(10) - Taragewicht[i];
          Gewicht[i] = ((float) l_gew) / Skalierung[i];
          if (quick) {
            LetztesGewicht[i] = Gewicht[i];
            break;
          }
          if (fabs(Gewicht[i] - LetztesGewicht[i]) < Diff_Gewicht) break; // Abweichung für Fehlererkennung
          LogDelay(2000); // Wartezeit zwischen Wiederholungen
        }
        LetztesGewicht[i] = Gewicht[i];
      }
      else {
        Gewicht[i] = No_Value; // Fehler
        debugprintF(" W fail");
      }
    }

    if (i == 1) {  // 2 Waagen
      scale.power_down();
    }
    else if ((i == 0) && (Anzahl_Sensoren_Gewicht == 1)) { // nur 1 Waage
      scale.power_down();
    }

    debugprintF("W ");
    debugprint(i + 1);
    debugprintF(" [kg] ");
    debugprintln(Gewicht[i]);
    debugflush();
  }
#endif
}
