//08.01.2023 HX711 / ProMini 8MHz
// 01.04.2023 Universal Platine 2.x
// 15.05.2023 BH1750 I2C Adressierung					   

//----------------------------------------------------------------
// Konfiguration DEBUG-Information
//               Serial Monitor via FTDI / USB
//----------------------------------------------------------------
#define myDEBUG 1     // Debug via Serial Monitor

//----------------------------------------------------------------
// Konfig der seriellen Schnittstelle
//----------------------------------------------------------------
#define Serial_Baudrate 9600
//----------------------------------------------------------------

//################################################################
// I2C Adressen
//################################################################

//----------------------------------------------------------------
// Konfiguration SHT31 - Temperatur und Luftfeuchte
//----------------------------------------------------------------
uint8_t SHT31_adresse[2] = {0x44, 0x45};
//----------------------------------------------------------------


//----------------------------------------------------------------
// Konfiguration BME280 - Temperatur und Luftfeuchte
//----------------------------------------------------------------
uint8_t BME280_adresse[2] = {0x76, 0x77};
//----------------------------------------------------------------

/****************************************************************/
// Konfiguration BH1750 - Licht
/****************************************************************/
// BH1750,  mögliche I2C Adressen
//   BH1750_DEFAULT_I2CADDR  0x23
//   BH1750_SECOND_I2CADDR   0x5C
/****************************************************************/
#define BH1750_ADRESS    0x23


//----------------------------------------------------------------
// Konfiguration Si7021 - Temperatur und Luftfeuchte
//----------------------------------------------------------------
// Si7021 I2C-Adresse : 0x40 (64d), Wert ist in Adafruit_Si7021.h
//----------------------------------------------------------------


//################################################################
// AT-Mega Pins
//################################################################

//----------------------------------------------------------------
// Konfiguration One-Wire-Bus für DS18B20
//----------------------------------------------------------------
#define ONE_WIRE_BUS 3
//----------------------------------------------------------------

//----------------------------------------------------------------
// Power on/off
//----------------------------------------------------------------
#define Power_Pin 4
//----------------------------------------------------------------

//----------------------------------------------------------------
// Konfiguration DHT21 / DHT22 - Temperatur und Luftfeuchte
// DHT Nr. 2 an D 6 nur bei Single/Duo-Systemen
//----------------------------------------------------------------
byte DHT_Sensor_Pin[2] = {5, 6}; // nur ein DHT
//----------------------------------------------------------------

//----------------------------------------------------------------
// Konfiguration HX711 SCK /Data
// Universal BZ - config same for all
// No need to use modified NANO
//----------------------------------------------------------------
uint8_t HX711_SCK[1] = {A0}; // HX711  S-Clock
uint8_t HX711_DT[1] =  {A1}; // HX711  Data
//----------------------------------------------------------------

//----------------------------------------------------------------
// Konfiguration ESP / SIM800
// Universal BZ - WLAN config same for all
// No need to use modified NANO
//----------------------------------------------------------------
// Pin Belegung ESP8266
#define ESP_RESET A2
uint8_t ESP_RX = 8;
uint8_t ESP_TX = 9;

//----------------------------------------------------------------

//----------------------------------------------------------------
// Seriellen Schnittstelle
//----------------------------------------------------------------
#define USB_RX      0          // Pin 0 RX-USB
#define USB_TX      1          // Pin 1 TX-USB
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interrupt
//----------------------------------------------------------------
#define DS3231_Interrupt_Pin 2
//----------------------------------------------------------------

//----------------------------------------------------------------
// I2C
//----------------------------------------------------------------
#define SDA   A4      // I2C Daten
#define SCL   A5      // I2C Clock
//----------------------------------------------------------------

//----------------------------------------------------------------
// Pins Spannungen messen
// Universal BZ - config same for all
// No need to use modified NANO
//----------------------------------------------------------------
#define Batterie_messen    A6
#define Solarzelle_messen  A7
//----------------------------------------------------------------


//################################################################
// Global Libraries
//################################################################
//#include <Sodaq_DS3231.h>
//#include <LowPower.h>
//----------------------------------------------------------------

//################################################################
// Debug Print Functions
//################################################################

#if myDEBUG == 1
#define debugbegin(x) Serial.begin(x)
#define debugprintF(x) Serial.print(F(x))
#define debugprintlnF(x) Serial.println(F(x))
#define debugprint(x) Serial.print(x)
#define debugprintln(x) Serial.println(x)
#define debugflush() Serial.flush()
#define debugend() Serial.end()
#else
#define debugbegin(x)
#define debugprintF(x)
#define debugprintlnF(x)
#define debugprint(x)
#define debugprintln(x)
#define debugflush()
#define debugend()
#endif

void Serial_rxtx_off() {
  delay(20);
  digitalWrite(USB_RX, LOW);   // Port aus
  pinMode(USB_TX, INPUT);
  digitalWrite(USB_TX, LOW);   // Port aus
}
//----------------------------------------------------------------
