/*
   (C) 2015 Thorsten Gurzan - beelogger.de

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter https://beelogger.de

#include <SPI.h>
#include <Ethernet.h>

// *********** start Konfiguration **************


// Hier muss eine eigene IP-Adresse, Gateway und DNS eingetragen werden,
// wenn die Netzwerkkonfiguration nicht über DHCP bezogen wird
// Sofern nicht mehrere Ethernet-Apdater gleichzeitig verwendet werden,
// braucht die MAC-Adresse nicht geändert werden
// Bitte darauf achten, dass die Adressen im Netzwerk nicht doppelt vergeben sind
byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
IPAddress ip(192, 168, 0, 10);
IPAddress gateway(192, 168, 0, 1);
IPAddress dnServer(192, 168, 0, 1);


// Domainname zum Webserver mit beelogger-Skript
const char serverName[] PROGMEM = "community.beelogger.de"; //"meineDomain.de";

// GET mit Verzeichnis auf dem Webserver und PHP-Skript für den jeweiligen beelogger
// Mit Anzahl_Sensoren_Gewicht
// 0/1 - Bsp: "GET /USERX/beelogger1/beelogger_log.php?"

const char beelogger_pfad[] PROGMEM = {"GET /USERX/beeloggerY/beelogger_log.php?"};   // "USERX" und "beeloggerY" ersetzen
// Passwort vom Webserver-Skript

// Passwort vom Webserver-Skript
const char Passwort[] PROGMEM = "Log";  // hier dein beelogger-log - Passwort

// *********** ende Konfiguration **************


EthernetClient client;

// Test-Messdaten (regulär kommen die Messdaten von den Sensoren)
float TempIn = 25.00;
float TempOut = 35.00;
float FeuchteIn = 40.00;
float FeuchteOut = 60.00;
float Licht = 5000.00;
float Gewicht = 25.00;
long BienenIn = 200;
long BienenOut = 500;

long Check;

void setup() {
  Serial.begin(9600);
  while (!Serial) {}
  Serial.println("beelogger Test W5100 01.03.2021");
  delay(5000);

  pinMode(4, OUTPUT);   // Pin 4 wird für die Deaktivierung der SD-Karte genutzt,
  digitalWrite(4, HIGH); // falls ein entsprechendes Ethernet-Shield mit SD-Adapter verwendet wird

  // Für Verwendung der Konfiguration über DHCP
  if (Ethernet.begin(mac) == 0) Serial.println("Fehler bei der Konfiguration des Ethernet-Adapters ueber DHCP");

  // Für Verwendung die eigenen Konfiguration
  // Ethernet.begin(mac, ip, dnServer, gateway);

  delay(1000);
}


void loop() {
  char parameter[80];

  Check = round(TempIn + TempOut + FeuchteIn + FeuchteOut + Licht + Gewicht + BienenIn + BienenOut);

  Serial.println(F("Verbinde zum Server ..."));

  for (byte i = 0; i < 3; i++) {  // Anzahl der Wiederholungen bei Verbindungsproblemen
    // oder korrupten Daten, die vom Webserver empfangen werden

    strcpy_P(parameter, serverName); // Server
    Serial.println(parameter);
    Serial.flush();

    if (client.connect(parameter, 80)) {
      strcpy_P(parameter, beelogger_pfad); // der GET in einen Stück bis zum '?'
      client.print(parameter);
      Serial.println(parameter);
      Serial.println(" ");
      Serial.flush();

      client.print ("Passwort=");
      strcpy_P(parameter, Passwort);
      client.print(parameter);

      client.print("&TempIn=");
      client.print (TempIn);

      client.print ("&TempOut=");
      client.print (TempOut);

      client.print ("&FeuchteIn=");
      client.print (FeuchteIn);

      client.print ("&FeuchteOut=");
      client.print (FeuchteOut);

      client.print ("&Licht=");
      client.print (Licht);

      client.print ("&Gewicht=");
      client.print (Gewicht);

      client.print ("&BienenIn=");
      client.print (BienenIn);

      client.print ("&BienenOut=");
      client.print (BienenOut);

      client.print ("&Check=");
      client.print (Check);

      client.println (" HTTP/1.1");
      client.print("Host:");
      strcpy_P(parameter, serverName); // Server
      client.println(parameter);
      client.println("Connection: close");
      client.println();

      delay(1000);

      Serial.println(F("Verbindung erfolgreich"));

    } else Serial.println(F("Verbindung fehlgeschlagen"));

    unsigned long start = millis();
    char c;
    while ((millis() - start < 2000) and (client.connected() )) {
      c = client.read();
      //Serial.print(c); //Debugausgabe
      if (c == '*') {
        i = 10;
        Serial.println(F("Upload erfolgreich"));
      }
    };

    client.stop();
    client.flush();

    delay(1000);

    Serial.println(F("Verbindung beendet"));
    Serial.println(" ");
  }
  // Test-Messdaten um 1 erhöhen
  TempIn++;
  TempOut++;
  FeuchteIn++;
  FeuchteOut++;
  Licht++;
  Gewicht++;
  BienenIn++;
  BienenOut++;
  Serial.println(F(" ... Senden in 5 Minuten"));
  Serial.flush();
  for (int i = 0; i < 300; i++) {
    delay(1000);
  }

}
