/*
   (C) 2017 Thorsten Gurzan - beelogger.de

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de
// Version 2.1

#include <SPI.h>

//----------------------------------------------------------------
// Konfiguration Ethernet - Internet
//----------------------------------------------------------------
#include <Ethernet.h>

// Hier muss eine eigene IP-Adresse, Gateway und DNS eingetragen werden,
// wenn die Netzwerkkonfiguration nicht über DHCP bezogen wird
// Sofern nicht mehrere Ethernet-Apdater gleichzeitig verwendet werden,
// braucht die MAC-Adresse nicht geändert werden
// Bitte darauf achten, dass die Adressen im Netzwerk nicht doppelt vergeben sind
byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
IPAddress ip {192, 168, 0, 10};
IPAddress gateway {192, 168, 0, 1};
IPAddress dnServer {192, 168, 0, 1};


// Domainname zum Webserver mit beelogger-Skript
const char server[] = "community.beelogger.de"; //"meineDomain.de";


// Verzeichnis in dem die Webserver-Skripte für den jeweiligen beelogger liegen (mit nachgestelltem "/")
// z.B. const char* pfad[1][1]={"beelogger1/"};
const char* pfad[1][1] = {"verzeichnis1/"};

// Passwort vom Webserver-Skript
static char Passwort[] = "!meinPasswort!";

EthernetClient client;
//----------------------------------------------------------------


//----------------------------------------------------------------
// Konfiguration RF433 - Funk
//----------------------------------------------------------------
#include <VirtualWire.h>
//----------------------------------------------------------------


//----------------------------------------------------------------
// Variablen
//----------------------------------------------------------------
float TempIn;
float TempOut;
float FeuchteIn;
float FeuchteOut;
float Licht;
long Gewicht;
long LetztesGewicht = 0;
long BienenIn;
long BienenOut;

long Check = 0;

float Temperatur[2];
float Luftfeuchte[2];

uint32_t LogDelayZeit;

int ID;
int LastID = 0;
char StringReceived[80];
//----------------------------------------------------------------



void setup() {

  //----------------------------------------------------------------
  // Setup Ethernet - Internet
  //----------------------------------------------------------------
  pinMode(4, OUTPUT); // Pin 4 wird fuer die Aktivierung bzw. Deaktivierung der SD-karte genutzt,
  digitalWrite(4, HIGH); // falls ein entsprechendesStandard-Shield verwendet wird

  Ethernet.begin(mac); // Für Verwendung der Konfiguration über DHCP

  // Ethernet.begin(mac, ip, dnServer, gateway);  // Für Verwendung der Werte der allgemeinen Konfiguration

  delay(1000);
  //----------------------------------------------------------------


  //----------------------------------------------------------------
  // Setup RF433 - Funk
  //----------------------------------------------------------------
  vw_set_rx_pin(2);
  vw_setup(2000);
  vw_rx_start();
  //----------------------------------------------------------------

}


void loop() {
  Empfangen_RF433_Speicher_Internet();
}


//----------------------------------------------------------------
// Funktion Ethernet - Internet
//----------------------------------------------------------------
void Speicher_Internet() {
  Check = round(TempIn + TempOut + FeuchteIn + FeuchteOut + Licht + Gewicht + BienenIn + BienenOut);

  for (byte i = 0; i < 5; i++) { // Anzahl der Wiederholungen bei Verbindungsproblemen
    // oder korrupten Daten, die vom Webserver empfangen werden

    if (client.connect(server, 80)) {

      client.print("GET /");
      client.print(pfad[0][0]);
      client.print("beelogger_log.php?TempIn=");
      client.print (TempIn);

      client.print ("&TempOut=");
      client.print (TempOut);

      client.print ("&FeuchteIn=");
      client.print (FeuchteIn);

      client.print ("&FeuchteOut=");
      client.print (FeuchteOut);

      client.print ("&Licht=");
      client.print (Licht);

      client.print ("&Gewicht=");
      client.print (Gewicht);

      client.print ("&BienenIn=");
      client.print (BienenIn);

      client.print ("&BienenOut=");
      client.print (BienenOut);

      client.print ("&Check=");
      client.print (Check);

      client.print ("&Passwort=");
      client.print (Passwort);

      client.println (" HTTP/1.1");
      client.print("Host:");
      client.println(server);
      client.println("Connection: close");
      client.println();

      delay(1000);
    }

    unsigned long start = millis();
    char  c;
    while ((millis() - start < 2000) and (client.connected() )) {
      c = client.read();
      if (c == '*') {
        i = 10;
      }
    }

    client.stop();
    client.flush();

    delay(1000);
  }
}
//----------------------------------------------------------------


//----------------------------------------------------------------
// Funktion RF433 - Funk
//----------------------------------------------------------------
void Empfangen_RF433_Speicher_Internet() {
  uint8_t buf[VW_MAX_MESSAGE_LEN];
  uint8_t buflen = VW_MAX_MESSAGE_LEN;

  long l_TempIn;
  long l_TempOut;
  long l_FeuchteIn;
  long l_FeuchteOut;
  long l_Licht;
  long l_Gewicht;

  if (vw_get_message(buf, &buflen)) {

    for (byte i = 0; i < buflen; i++) {
      StringReceived[i] = char(buf[i]);
    }

    sscanf(StringReceived, "%d,%ld,%ld, %ld, %ld,%ld,%ld,%ld,%ld", &ID, &l_TempIn, &l_TempOut, &l_FeuchteIn, &l_FeuchteOut, &l_Licht, &l_Gewicht, &BienenIn, &BienenOut);

    TempIn = ((float) l_TempIn) / 100;
    TempOut = ((float) l_TempOut) / 100;
    FeuchteIn = ((float) l_FeuchteIn) / 100;
    FeuchteOut = ((float) l_FeuchteOut) / 100;
    Licht = ((float) l_Licht) / 100;
    Gewicht = ((float) l_Gewicht) / 100;

    if (ID != LastID) {
      Speicher_Internet();
      LastID = ID;
    }
    memset(StringReceived, 0, sizeof(StringReceived));
    delay(5);
  }
}
//----------------------------------------------------------------
