/*
 * (C) 2017 Thorsten Gurzan - beelogger.de
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de
// Version 2.0

#include <SPI.h>

//----------------------------------------------------------------
// Konfiguration Ethernet - Internet
//----------------------------------------------------------------
#include <Ethernet.h> 

// Hier muss eine eigene IP-Adresse, Gateway und DNS eingetragen werden, 
// wenn die Netzwerkkonfiguration nicht über DHCP bezogen wird
// Sofern nicht mehrere Ethernet-Apdater gleichzeitig verwendet werden, 
// braucht die MAC-Adresse nicht geändert werden
// Bitte darauf achten, dass die Adressen im Netzwerk nicht doppelt vergeben sind
byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
IPAddress ip(192,168,0,10);
IPAddress gateway(192,168,0,1);
IPAddress dnServer(192,168,0,1);


// Domainname zum Webserver mit beelogger-Skript
const char server[] = "community.beelogger.de"; //"meineDomain.de"; 

// Verzeichnis in dem die Webserver-Skripte für den jeweiligen beelogger liegen (mit nachgestelltem "/") 
// const char* pfad[1][6]={"beelogger1/","beelogger2/","beelogger3/","beelogger4/","beelogger5/","beelogger6/"};
const char* pfad[1][6]={"verzeichnis1/","verzeichnis2/","verzeichnis3/","verzeichnis4/","verzeichnis5/","verzeichnis6/"};

// Passwort vom Webserver-Skript
static char Passwort[] = "!meinPasswort!";

EthernetClient client;
//----------------------------------------------------------------


//----------------------------------------------------------------
// Konfiguration nRF24L01 - Funk
//----------------------------------------------------------------
#include <RF24.h> 
RF24 radio(8,7);

static const uint64_t pipes[6] = {0xF0F0F0F0E1LL, 0xF0F0F0F0D2LL, 0xF0F0F0F0C3LL, 0xF0F0F0F0B4LL, 0xF0F0F0F0A5LL, 0xF0F0F0F096LL};
//----------------------------------------------------------------


//----------------------------------------------------------------
// Variablen
//----------------------------------------------------------------
float TempIn;
float TempOut;
float FeuchteIn;
float FeuchteOut;
float Licht;
long Gewicht;
long LetztesGewicht = 0;
long BienenIn;
long BienenOut;

long Check = 0;
uint8_t ClientNummer;

float Temperatur[2];
float Luftfeuchte[2];

uint32_t LogDelayZeit;
//----------------------------------------------------------------



void setup() {
 
//----------------------------------------------------------------
// Setup Ethernet - Internet
//----------------------------------------------------------------
pinMode(4,OUTPUT);  // Pin 4 wird fuer die Aktivierung bzw. Deaktivierung der SD-karte genutzt, 
digitalWrite(4,HIGH);  // falls ein entsprechendesStandard-Shield verwendet wird 

Ethernet.begin(mac); // Für Verwendung der Konfiguration über DHCP

// Ethernet.begin(mac, ip, dnServer, gateway);  // Für Verwendung der Werte der allgemeinen Konfiguration    
     
delay(1000);
//----------------------------------------------------------------


//----------------------------------------------------------------
// Setup nRF24L01 - Funk
//----------------------------------------------------------------    
radio.begin();
delay(20);
radio.setChannel(1);                // Funkkanal - Mögliche Werte: 0 - 127   
radio.setAutoAck(0);     
radio.setPALevel(RF24_PA_HIGH);     // Sendestärke darf die gesetzlichen Vorgaben des jeweiligen Landes nicht überschreiten! 
                                    // RF24_PA_MIN=-18dBm, RF24_PA_LOW=-12dBm, RF24_PA_MED=-6dBM, and RF24_PA_HIGH=0dBm

radio.openReadingPipe(0,pipes[0]);
radio.openReadingPipe(1,pipes[1]);
radio.openReadingPipe(2,pipes[2]);
radio.openReadingPipe(3,pipes[3]);
radio.openReadingPipe(4,pipes[4]);
radio.openReadingPipe(5,pipes[5]);  
 
radio.startListening();
delay(20); 
//----------------------------------------------------------------  

}


void loop() {
  Empfangen_nRF24L01_Speicher_Internet();
}


//----------------------------------------------------------------
// Funktion Ethernet - Internet
//----------------------------------------------------------------
void Speicher_Internet() {
  Check = round(TempIn+TempOut+FeuchteIn+FeuchteOut+Licht+Gewicht+BienenIn+BienenOut);
   
  for (byte i = 0; i < 5; i++) { // Anzahl der Wiederholungen bei Verbindungsproblemen 
                                 // oder korrupten Daten, die vom Webserver empfangen werden
  
    if (client.connect(server, 80)){
      
      client.print("GET /");
      client.print(pfad[0][ClientNummer]);                    
      client.print("beelogger_log.php?TempIn=");
      client.print (TempIn);
      
      client.print ("&TempOut=");
      client.print (TempOut);
      
      client.print ("&FeuchteIn=");
      client.print (FeuchteIn);   
      
      client.print ("&FeuchteOut=");
      client.print (FeuchteOut);  
   
      client.print ("&Licht=");
      client.print (Licht);
      
      client.print ("&Gewicht=");
      client.print (Gewicht);
      
      client.print ("&BienenIn=");
      client.print (BienenIn);  
      
      client.print ("&BienenOut=");
      client.print (BienenOut);
      
      client.print ("&Check=");
      client.print (Check);
      
      client.print ("&Passwort=");
      client.print (Passwort);
        
      client.println (" HTTP/1.1");
      client.print("Host:");
      client.println(server);
      client.println("Connection: close");
      client.println();  
      
      delay(1000);     
    } 
   
    unsigned long start = millis();
    char  c;
    while ((millis() - start < 2000) and (client.connected() )) {
      c = client.read();   
      if (c=='*') {
        i=10;
      }
    } 
           
    client.stop();      
    client.flush(); 

    delay(1000);     
  }
}
//----------------------------------------------------------------


//----------------------------------------------------------------
// Funktion nRF24L01 - Funk
//----------------------------------------------------------------
void Empfangen_nRF24L01_Speicher_Internet() {
  if (radio.available(&ClientNummer)){
    long got_message[8] = {0,0,0,0,0,0,0,0};
      
    bool done = false;
    while (!done){
      done = radio.read(&got_message, sizeof(got_message));
    } 
    
    TempIn = (float (got_message[0])/100);
    TempOut = (float (got_message[1])/100);
    FeuchteIn = (float (got_message[2])/100);
    FeuchteOut = (float (got_message[3])/100);
    Licht = (float (got_message[4])/100);
    Gewicht = got_message[5];
    BienenIn = got_message[6];
    BienenOut = got_message[7];
    
    Speicher_Internet();
  }
}
//----------------------------------------------------------------
